import { Checkbox } from "@/components/ui/checkbox";
import { Button } from "@/components/ui/button";
import { MoreVertical, Edit, Trash2, GripVertical } from "lucide-react";
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import { Badge } from "@/components/ui/badge";

type StepStatus = "pending" | "in-progress" | "completed";

interface StepItemProps {
  id: string;
  text: string;
  status: StepStatus;
  onToggle?: () => void;
  onEdit?: () => void;
  onDelete?: () => void;
}

const statusConfig = {
  pending: { label: "Pending", className: "bg-muted" },
  "in-progress": { label: "In Progress", className: "bg-warning text-warning-foreground" },
  completed: { label: "Completed", className: "bg-success text-success-foreground" },
};

export function StepItem({ id, text, status, onToggle, onEdit, onDelete }: StepItemProps) {
  const config = statusConfig[status];

  return (
    <div
      className="flex items-center gap-3 p-3 rounded-lg border border-card-border hover-elevate transition-all"
      data-testid={`step-${id}`}
    >
      <GripVertical className="h-4 w-4 text-muted-foreground cursor-grab" />
      
      <Checkbox
        checked={status === "completed"}
        onCheckedChange={onToggle}
        data-testid={`checkbox-step-${id}`}
        className="h-5 w-5"
      />

      <div className="flex-1 min-w-0">
        <p className={`text-sm ${status === "completed" ? "line-through text-muted-foreground" : ""}`}>
          {text}
        </p>
      </div>

      <Badge variant="secondary" className={`${config.className} text-xs`} data-testid={`badge-status-${id}`}>
        {config.label}
      </Badge>

      <DropdownMenu>
        <DropdownMenuTrigger asChild>
          <Button variant="ghost" size="icon" className="h-8 w-8" data-testid={`button-step-menu-${id}`}>
            <MoreVertical className="h-4 w-4" />
          </Button>
        </DropdownMenuTrigger>
        <DropdownMenuContent align="end">
          <DropdownMenuItem onClick={onEdit} data-testid={`button-edit-step-${id}`}>
            <Edit className="h-4 w-4 mr-2" />
            Edit
          </DropdownMenuItem>
          <DropdownMenuItem onClick={onDelete} className="text-destructive" data-testid={`button-delete-step-${id}`}>
            <Trash2 className="h-4 w-4 mr-2" />
            Delete
          </DropdownMenuItem>
        </DropdownMenuContent>
      </DropdownMenu>
    </div>
  );
}
