import { Plus } from "lucide-react";
import { Button } from "@/components/ui/button";

interface FABProps {
  onClick?: () => void;
}

export function FAB({ onClick }: FABProps) {
  return (
    <Button
      size="icon"
      className="fixed bottom-20 right-6 md:bottom-8 h-14 w-14 rounded-full shadow-2xl z-40"
      onClick={onClick}
      data-testid="button-fab-create-plan"
    >
      <Plus className="h-6 w-6" />
    </Button>
  );
}
