import { Sparkles, X, RefreshCw } from "lucide-react";
import { Card } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { useState } from "react";

interface AISuggestionBoxProps {
  suggestion: string;
  onApply?: () => void;
  onRegenerate?: () => void;
  onDismiss?: () => void;
}

export function AISuggestionBox({
  suggestion,
  onApply,
  onRegenerate,
  onDismiss,
}: AISuggestionBoxProps) {
  const [isVisible, setIsVisible] = useState(true);

  if (!isVisible) return null;

  const handleDismiss = () => {
    setIsVisible(false);
    onDismiss?.();
  };

  return (
    <Card className="p-4 border-l-4 border-l-ai-accent bg-card" data-testid="ai-suggestion-box">
      <div className="space-y-3">
        <div className="flex items-start justify-between gap-3">
          <div className="flex items-start gap-3 flex-1">
            <div className="p-2 rounded-lg bg-ai-accent/10">
              <Sparkles className="h-4 w-4 text-ai-accent" />
            </div>
            <div className="flex-1 min-w-0">
              <h4 className="font-semibold text-sm mb-1">AI Suggestion</h4>
              <p className="text-sm font-mono text-muted-foreground leading-relaxed">
                {suggestion}
              </p>
            </div>
          </div>
          <Button
            variant="ghost"
            size="icon"
            className="h-6 w-6"
            onClick={handleDismiss}
            data-testid="button-dismiss-suggestion"
          >
            <X className="h-4 w-4" />
          </Button>
        </div>

        <div className="flex items-center gap-2 pt-1">
          <Button
            size="sm"
            onClick={onApply}
            data-testid="button-apply-suggestion"
          >
            Apply
          </Button>
          <Button
            variant="outline"
            size="sm"
            onClick={onRegenerate}
            data-testid="button-regenerate-suggestion"
          >
            <RefreshCw className="h-3 w-3 mr-2" />
            Regenerate
          </Button>
        </div>
      </div>
    </Card>
  );
}
